parcel_services.controllers.module('create-modal',
	['xhr', `${gx.source}/libs/info_messages`,],
	() => {
		return {
			vue: true,
			name: 'gx-create-modal',
			template: '#create-modal',
			parent: 'gx-parcel-services-overview',
			props: ['languages'],
			data: () => ({
				lang: {
					title: jse.core.lang.translate('create_modal_title', 'parcel_services'),
					close: jse.core.lang.translate('cancel', 'buttons'),
					confirm: jse.core.lang.translate('create', 'buttons'),
					labels: {
						name: jse.core.lang.translate('label_name', 'parcel_services'),
						isDefault: jse.core.lang.translate('label_set_as_default', 'parcel_services'),
						comment: jse.core.lang.translate('label_comment', 'parcel_services'),
						url: jse.core.lang.translate('label_url', 'parcel_services'),
						placeholder: jse.core.lang.translate('label_tracking_number_placeholder', 'parcel_services'),
					},
				},
				details: {
					name: '',
					isDefault: false,
					descriptions: {}
				},
				validFormData: {
					name: true,
				},
				selectedLanguage: '',
			}),
			methods: {
				resetModal() {
					this.details.name = '';
					this.details.isDefault = false;
					this.descriptions = [];
					for (const i in this.languages) {
						this.details.descriptions[this.languages[i].id] = {
							languageId: this.languages[i].id,
							url: '',
							comment: '',
						};
					}
					this.validFormData.name = true;
					if (this.$children[0] !== undefined) {
						this.$children[0].input = this.details.isDefault;
					}
				},
				confirm() {
					if (this.checkFormData() === false) {
						return;
					}
					
					jse.libs.xhr.post({
						url: './api/parcel-services',
						data: this.details
					}).done(response => {
						this.$emit('reload-overview');
					}).fail((response) => {
						console.error('Could not create parcel service.', response);
						jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_create_parcel_service', 'parcel_services'));
					});
					$('.create-modal.modal').modal('hide');
				},
				checkFormData() {
					this.validFormData.name = this.details.name.trim().length !== 0;
					
					return this.validFormData.name;
				},
				changeLanguage(languageId) {
					this.selectedLanguage = languageId;
					if (this.details.descriptions[languageId] === undefined) {
						this.details.descriptions[languageId] = {
							languageId: languageId,
							url: '',
							comment: '',
						};
					}
				},
				openModal(details) {
					this.selectedLanguage = this.languages[0].id;
					this.resetModal();
					gx.widgets.init($('.create-modal.modal'));
					$('.create-modal.modal').modal('show');
				},
			},
			init: done => done()
		}
	});